
@rem --- Set this to the base name of the wad you wish to create ---
@set WADBASE=%1

@rem --- Values used in the pica response file
@set RENDERSTART=1
@set RENDEREND=254

@echo -======================================
@echo  Building Wad file: %WADBASE%.wad
@echo -======================================

@echo off

rem --- Ensure the correct directory structure ---
 md 8bit
 md 8bit_wad

rem --- Pre-Cleanup ---
 del 8bit\*.*
 del 8bit_wad\*.*
 del pica.wad.rsp
 del %WADBASE%.ls
 del %WADBASE%.wad

rem --- Create the pica response file - have to respect the batch file ---
 echo quantizeRGB() >> pica.wad.rsp
 echo outputPath(8bit) >> pica.wad.rsp
 echo palOutputName(8bit\%WADBASE%.pal) >> pica.wad.rsp
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> pica.wad.rsp
 echo chooseRange(%RENDERSTART%, %RENDEREND%) >> pica.wad.rsp
 echo paletteKey(1) >> pica.wad.rsp
 echo bitmapListStart() >> pica.wad.rsp
 echo %WADBASE%\*.bmp >> pica.wad.rsp

rem --- Convert source to 8bit art ---
 ..\bin\picanew @pica.wad.rsp
 
rem --- Strip the reserved bytes from the bitmaps ---
 ..\bin\bmpconv -d 8bit 8bit_wad
 
rem --- Create the quake wad3 file ---
 ..\bin\makels 8bit_wad %WADBASE% %WADBASE%.ls
 ..\bin\qlumpy %WADBASE%.ls

rem --- Post-Cleanup ---
 del 8bit\output.pal
 del pica.wad.rsp
 del 8bit_wad\*.*
 del %WADBASE%.ls
